-- A7 Sam Rogers, Bryce Green, Patrick Mohr, Niel Tarr 

--1. List the customers from California who bought red mountain bikes in September 2003.  Use order date as date bought.

 SELECT C.CustomerID, C.FirstName, C.LASTNAME, B.ModelType, P.ColorList, B.Orderdate, B.SaleState 
 FROM Bike..Paint P Inner Join Bike..Bicycle B ON B.PaintID = P.PaintID Inner Join 
	  Bike..Customer C ON C.CustomerID = B.CustomerID  
 WHERE  B.SaleState = 'CA' AND P.ColorList = 'RED' AND B.ModelType = 'Mountain' AND B.OrderDate >= '9-1-2003' AND B.OrderDate <= '9-30-2003'

--2. List the employees who sold race bikes shipped to Wisconsin without the help of a retail store in 2001
SELECT E.EmployeeID, E.LastName,  B.ModelType, B.OrderDate, B.StoreID, B.SaleState
FROM Bike..Employee E Inner Join Bike..Bicycle B ON E.EmployeeID = B.EmployeeID
WHERE B.SaleState = 'WI' AND B.ModelType = 'RACE' AND (B.StoreID = 1 or B.StoreID = 2) AND B.OrderDate >= '1-1-2001' AND B.OrderDate <= '12-31-2001'   

--3. List all of the (distinct) rear derailleurs installed on road bikes sold in Florida in 2002.
SELECT	DISTINCT C.ComponentID, M.ManufacturerName ,C.ProductNumber
FROM	Bike..Component C INNER JOIN Bike..BikeParts P ON C.ComponentID = P.ComponentID INNER JOIN Bike..Bicycle B ON P.SerialNumber = B.SerialNumber INNER JOIN Bike..Manufacturer M ON C.ManufacturerID = M.ManufacturerID
WHERE	C.Category = 'rear derailleur' AND B.ModelType = 'road' and B.SaleState = 'FL' AND B.OrderDate >= '1-1-2002' and B.OrderDate <= '12-31-2002'

--4.  Who bought the largest (frame size) full suspension mountain bike sold in Georgia in 2004?

SELECT  TOP 1U.CUSTOMERID, U.LastName, U.FirstName, B.ModelType,  B.SaleState, B.FrameSize, B.OrderDate
FROM	Bike..Customer U INNER JOIN Bike..Bicycle B ON U.CustomerID = B.CustomerID INNER JOIN Bike..BikeParts P ON P.SerialNumber = B.SerialNumber 
WHERE   B.SaleState = 'GA' 
		AND B.OrderDate >= '1-1-2004' 
		and B.OrderDate <= '12-31-2004' 
		AND B.ModelType = 'Mountain full' 

GROUP BY U.CustomerID, U.FirstName, U.LastName, B.ModelType,  B.SaleState, B.FrameSize, B.OrderDate
ORDER BY B.FrameSize Desc
--5. Which manufacturer gave us the largest discount on an order in 2003?
SELECT M.ManufacturerID, M.ManufacturerName
FROM Bike..Manufacturer M INNER Join Bike..Component C ON M.ManufacturerID = C.ManufacturerID 
						  INNER JOIN Bike..PurchaseItem P ON C.ComponentID = P.ComponentID 
						  INNER JOIN Bike..PurchaseOrder O ON P.PurchaseID = O.PurchaseID
WHERE O.OrderDate >= '1-1-2003' 
	  AND O.OrderDate <= '12-31-2003' 
	  AND O.Discount = (SELECT TOP 1 Discount
						FROM Bike..PurchaseOrder
						WHERE OrderDate >= '1-1-2003' 
						AND OrderDate <= '12-31-2003'
						ORDER BY Discount DESC)
Group BY M.ManufacturerID, M.ManufacturerName



--6 What is the most expensive road bike component we stock that has a quantity on hand greater than 200 units? 
SELECT TOP 1 C.ComponentID, M.ManufacturerName, C.ProductNumber, B.ModelType AS 'ROAD', C.Category,  C.ListPrice, C.QuantityonHand
FROM Bike..Manufacturer M INNER JOIN Bike..Component C ON M.ManufacturerID = C.ManufacturerID 
						  INNER JOIN Bike..BikeParts P ON C.ComponentID = P.ComponentID 
						  INNER JOIN BIKE..Bicycle B ON P.SerialNumber = B.SerialNumber 
WHERE C.QuantityOnHand > 200
	  AND B.ModelType = 'road' 
	 
GROUP BY C.ComponentID, M.ManufacturerName, C.ProductNumber, B.ModelType, C.Category, C.ListPrice, C.QuantityonHand
ORDER BY C.ListPrice Desc
--7. Which inventory item represents the most money sitting on the shelfbased on estimated cost?

 SELECT TOP 1 C.COMPONENTID, M.MANUFACTURERNAME, C.PRODUCTNUMBER, C.CATEGORY, C.Year, ROUND(C.EstimatedCost*C.QuantityOnHand,2) AS [VALUE]
FROM	BIKE..Component C INNER JOIN BIKE..Manufacturer M ON C.ManufacturerID = M.ManufacturerID
ORDER BY VALUE DESC

--8. What is the greatest number of components ever installed in one day by one employee?
SELECT TOP 1 E.EmployeeID, E.LastName, P.DateInstalled, COUNT(P.COMPONENTID) AS CountOfComponentID
FROM	BIKE..Employee E INNER JOIN BIKE..Bicycle B ON E.EmployeeID = B.EmployeeID INNER JOIN BIKE..BikeParts P ON B.SerialNumber = P.SerialNumber
GROUP BY E.EmployeeID, E.LastName, P.DateInstalled
ORDER BY CountOfComponentID DESC

--9. What was the most popular letter style on race bikes in 2003?
SELECT  TOP 1 L.LetterStyle, COUNT(L.LetterStyle) AS CountOfSerialNumber
FROM Bike..Bicycle E Inner JOIN Bike..LetterStyle L ON L.LetterStyle = E.LetterStyleID
WHERE E.ModelType = 'Race'  AND  E.OrderDate >= '1-1-2003' AND E.OrderDate <= '12-31-2003'
GROUP BY l.LetterStyle
ORDER BY CountOfSerialNumber DESC

--10. Which customer spent the most money with us and how many bicycles did that person buy in 2002?
SELECT TOP 1 C.CustomerID, C.FirstName, C.LastName, COUNT(B.SerialNumber) AS [Number of Bikes], SUM(T.Amount) AS [Amount Spent] 
FROM  Bike..Customer C INNER JOIN Bike..CustomerTransaction T  ON C.CustomerID = T.CustomerID INNER JOIN Bike..Bicycle B ON B.CustomerID = C.CustomerID
WHERE YEAR(T.TransactionDate) = '2002' AND T.Amount > 0  
GROUP BY C.CustomerID, C.FirstName, C.LastName
ORDER BY SUM(T.Amount) DESC


Select SerialNumber, SalePrice
from Bike..Bicycle
WHERE OrderDate >= '1-1-2002' AND OrderDate <= '12-31-2002' 
Order by SalePrice Desc

--11. Have the sales of mountain bikes (full suspension or hard tail) increased or decreased from 2000 to 2004 (by count not by value)?
SELECT YEAR(OrderDate) AS SaleYear, COUNT(SerialNumber) AS [Count Of Serial Number ] 
FROM Bike..Bicycle
WHERE YEAR(OrderDate) >= '2000' AND YEAR(OrderDate) <= '2004' AND (ModelType = 'Mountain Full' OR ModelType = 'Mountain')
GROUP BY YEAR(OrderDate)
ORDER BY SaleYear

--12. Which component did the company spend the most money on in 2003?
SELECT TOP 1 C.ComponentID, M.ManufacturerName, C.ProductNumber, C.Category, MAX(I.PricePaid) AS [Value] 
FROM Bike..Component C Inner Join Bike..Manufacturer M ON M.ManufacturerID = C.ManufacturerID 
					   INNER JOIN Bike..PurchaseItem I ON I.ComponentID = C.ComponentID 
					   INNER JOIN Bike..PurchaseOrder P ON P.PurchaseID = I.PurchaseID
WHERE YEAR(P.OrderDate) = 2003
GROUP BY C.ComponentID, M.ManufacturerName, C.ProductNumber, C.Category
ORDER BY Value DESC
					 
--13. Which employee painted the most red race bikes in May 2003?

SELECT E.LastName, E.EmployeeID, COUNT(B.SerialNumber) AS [Number Painted] 
FROM Bike..Paint P INNER JOIN Bike..Bicycle B ON B.PaintID = P.PaintID INNER JOIN Bike..Employee E ON E.EmployeeID = B.EmployeeID
WHERE YEAR(OrderDate) = '2003' AND MONTH(OrderDate) = '5' AND B.ModelType =  'RACE' AND P.ColorList = 'RED' 
GROUP BY E.EmployeeID, E.LastName
ORDER BY [Number Painted] DESC

--14. Which California bike shop helped sell the most bikes (by value) in 2003?
SELECT R.StoreID, R.StoreName, C.City, SUM(B.SalePrice) AS [SUM of SALE PRICE]
FROM Bike..RetailStore R INNER JOIN Bike..City C ON C.CityID = R.CityID 
						 INNER JOIN Bike..Bicycle B ON B.StoreID = R.StoreID
WHERE YEAR(B.OrderDate) = '2003'  AND B.SaleState = 'CA' 
GROUP BY R.StoreID, R.StoreName, C.City
ORDER BY [SUM of SALE PRICE] DESC 


--15. What is the total weight of the components on bicycle 11356?
SELECT SUM(C.Weight) AS [Total Weight] 
FROM Bike..BikeParts BP INNER JOIN Bike..Component C ON C.ComponentID = BP.ComponentID
WHERE BP.SerialNumber = 11356


--16.  What is the total list price of all items in the 2002 Campy Record groupo?
SELECT GP.GroupName, SUM(C.LISTPRICE) AS [SUM OF LIST PRICE] 
FROM Bike..Groupo GP INNER JOIN Bike..GroupComponents GC ON GP.ComponentGroupID = GC.GroupID 
                     INNER JOIN Bike..Component C ON C.ComponentID = GC.ComponentID 
WHERE GP.GroupName = 'Campy Record 2002' 
GROUP BY GP.GroupName
ORDER BY [SUM OF LIST PRICE]

--17. In 2003, were more race bikes built from carbon or titanium (based on the down tube)?
SELECT TM.Material, COUNT(B.SerialNumber) AS [COUNT OF SERIAL NUMBER] 
FROM BIKE..Bicycle B INNER JOIN Bike..BicycleTubeUsage BTU ON BTU.SerialNumber = B.SerialNumber 
                     INNER JOIN BIKE..TubeMaterial TM ON BTU.TubeID = TM.TubeID
WHERE B.ModelType = 'race' AND YEAR(OrderDate) = '2003' AND (TM.Material = 'carbon fiber' OR TM.Material = 'titanium') 
GROUP BY TM.Material
ORDER BY [COUNT OF SERIAL NUMBER] DESC

--18.  What is the average price paid for the 2001 Shimano XTR rear derailleurs?
SELECT	AVG(PT.PricePaid) AS [Average List Price] 
FROM	BIKE..PurchaseItem PT INNER JOIN Bike..Component C ON PT.ComponentID = C.ComponentID 
                           INNER JOIN Bike..PurchaseOrder PO ON PT.PurchaseID = PO.PurchaseID 
						   INNER JOIN Bike..GroupComponents GC ON C.ComponentID = GC.ComponentID 
						   INNER JOIN Bike..Groupo G ON G.ComponentGroupID = GC.GroupID
WHERE	C.Category = 'rear derailleur' AND G.GroupName = 'Shimano XTR 2001'
ORDER BY [Average List Price] 

--19. What is the average top tube length for a 54 cm (frame size) road bike built in 1999?
SELECT  AVG(TopTube) AS [AVERAGE of TOP Tube] 
FROM	Bike..Bicycle
WHERE	FrameSize = '54' AND ModelType = 'ROAD' AND YEAR(OrderDate) = '1999' 

--20. On average, which costs (list price) more: road tires or mountain bike tires?
select	Road, AVG(ListPrice) as [AvgListPrice]
from	bike..Component
where	Road = 'Road' OR Road = 'MTB'
group by Road
order by [AvgListPrice] Desc

--21 In May 2003, which employees sold road bikes that they also painted?
Select	B.EmployeeID, E.LastName
FROM	Bike..Bicycle B INNER JOIN Bike..Employee E on B.EmployeeID = E.EmployeeID
Where	B.ModelType = 'Road' AND YEAR(b.OrderDate) = '2003' AND Month(OrderDate) = '5'
						   AND B.Painter = B.EmployeeID
Group By B.EmployeeID, E.LastName
Order By E.LastName

--22 In 2002, was the Old English letter style more popular with some paint jobs?
Select	P.PaintID, P.ColorName, COUNT(B.SerialNumber) as [Number of Bikes Painted]
From	Bike..Bicycle B INNER JOIN Bike..Paint P on B.PaintID = P.PaintID
WHERE	YEAR(B.OrderDate) = '2002' and B.LetterStyleID = 'English'
Group BY P.PaintID, P.ColorName
Order BY [Number of Bikes Painted] Desc

select *
from bike..Bicycle
--23 Which race bikes in 2003 sold for more than the average price of race bikes in 2002?
SELECT SalePrice, SerialNumber, ModelType, OrderDate
FROM Bike..Bicycle 
WHERE YEAR(OrderDate) = '2003' AND ModelType = 'race' AND SalePrice > (SELECT AVG(SalePrice) FROM Bike..Bicycle WHERE YEAR(OrderDate) = '2002' AND ModelType = 'race') 
GROUP BY SerialNumber, ModelType, OrderDate, SalePrice
ORDER By SalePrice


--24. Which component that had no sales (installations) in 2004 has the highest inventory value (cost basis)?
SELECT	TOP 1 M.ManufacturerName, C.ProductNumber, C.Category, SUM(C.ListPrice * C.QuantityOnHand) AS [Value], C.ComponentID
FROM	BIKE..COMPONENT C INNER JOIN BIKE..Manufacturer M ON C.ManufacturerID = M.ManufacturerID 
			           INNER JOIN BIKE..BikeParts P ON P.ComponentID = C.ComponentID
WHERE YEAR(P.DateInstalled) <> '2004'
GROUP BY M.ManufacturerName, C.ProductNumber, C.Category,C.ComponentID, P.DateInstalled
ORDER BY [Value] DESC

--25. Create a vendor contacts list of all manufacturers and retail stores in California. Include only the columns for VendorName and Phone. The retail stores should only include stores that participated in the sale of at least one bicycle in 2004
SELECT R.StoreName as 'Store Name Or Manufacturer Name', R.Phone 
FROM Bike..RetailStore R INNER JOIN Bike..Bicycle B ON B.StoreID = R.StoreID INNER JOIN Bike..City C ON C.CityID = R.CityID
WHERE b.SaleState = 'CA' AND YEAR(B.OrderDate) = '2004' 
GROUP BY R.StoreName, R.Phone

--26 List all of the employees who report to Venetiaan.
SELECT (SELECT LastName FROM Bike..Employee WHERE EmployeeID = (SELECT EmployeeID FROM Bike..Employee WHERE LastName = 'VENETIAAN')) AS [MGR Name], EmployeeID, FirstName, LastName, Title
FROM Bike..Employee
WHERE CurrentManager = (SELECT EmployeeID FROM Bike..Employee WHERE LastName = 'VENETIAAN')
--27. List the components where the company purchased at least 25 percent more units than it used through June 30, 2000.


--28 In which years did the average build time for the year exceed the overall average build time for all years?  The build time is the difference between order date and ship date.
SELECT YEAR(OrderDate) AS [Year], AVG(DATEDIFF( DAY, ORDERDATE, ShipDate)) AS [Build Time] 
FROM Bike..Bicycle
GROUP BY YEAR(OrderDate)
HAVING  AVG(DATEDIFF(DAY, OrderDate, ShipDate)) > (SELECT AVG(DATEDIFF(DAY, OrderDate, ShipDate)) FROM Bike..Bicycle)
